/* part of the shansyn spherical harmonics package, see COPYRIGHT for license */
/* 

converts old model format to new spherical harmonics format


*/
/* $Id: convert_she_model.c,v 1.2 2005/04/05 19:06:14 becker Exp becker $ */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "function_macros.h"
#include "trig_constants.h"
#include "precision.h"
#include "spherical_harmonics_functions.h"
#include "legendre_macros.h"
#include "myio.h"

int main(int argc, char **argv)
{
  struct mod model[1];
  COMP_PRECISION fac=1.0;
  switch(argc){
  case 2:
    break;
  case 3:
    sscanf(argv[2],DATA_FSCAN_FORMAT,&fac);
    break;
  default:
    fprintf(stderr,"%s model_file [fac, %g]\n",argv[0],fac);
    fprintf(stderr,"\tconverts spherical harmonic expansion from model model_file\n");
    fprintf(stderr,"\tto the new format as used by the hc Hager & O'Connell code\n");
    exit(-1);
    break;
  }
  read_she_model(argv[1],model,-1,1);

  model[0].type = HC_TYPE;
  write_model(model,fac,1);
  return 0;
}

