/* part of the shansyn spherical harmonics package, see COPYRIGHT for license */
/* $Id: extract_model_depths.c,v 1.4 2005/04/05 19:06:14 becker Exp becker $ */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "function_macros.h"
#include "trig_constants.h"
#include "precision.h"
#include "spherical_harmonics_functions.h"
#include "legendre_macros.h"
//
// extract depth layers of a spherical harmonic model
//
int main(int argc, char **argv)
{
 
  int i,nexp=1;
  struct mod model[3];
  switch(argc){
  case 2:
    break;
  case 3:
    sscanf(argv[2],"%i",&nexp);
    break;
  default:{
    fprintf(stderr,"%s file1 [nexp, %i]\n",argv[0],nexp);
    fprintf(stderr,"writes depth layers of model to stdout\n");
    exit(-1);
    break;
  }}
  if(nexp > 3){
    fprintf(stderr,"%s: error, too many expansions: %i (<3)\n",
	    argv[0],nexp);
    exit(-1);
  }
  read_she_model(argv[1],model,-1,nexp);
  for(i=0;i < model[0].n;i++)
    printf("%3i %11g\n",i+1,model[0].d[i]);
  return 0;
}

