import time
from Numeric import *
from FFT import *

def PtSample(n, step=1, type='FFT'):
    if type=='FFT':
        if step: tmp=arange(0, n*step, step, Float)
        else: tmp=zeros(n, Float)
    elif type=='FD':
        if step: tmp=arange(0, (n+1)*step, step, Float)
        else: tmp=zeros(n+1, Float)
    else:
        raise '"Type" not valid!'
    return tmp

def PtIndex(n1, n2, step=1, type='FFT'):
    if type=='FFT':
        tmp=range(n1,n2,step)
    elif type=='FD':
        tmp=range(n1,n2+1,step)
    else:
        raise '"Type" not valid!'
    return tmp

def FourierCoeff(n, d):
    wk=zeros(n,Float)
    pdn= pi*2./(d*n)
    n2=n/2
    if n2 >= 2:
        for i in range(1,n):
            if i<n2:
                wk[i] = pdn*i
            else:
                wk[i]=-pdn*(n-i)
    return wk

def FourierDeriv(func, order=1, coeff=None):
    ....
    return func

# ==============================================================================

def FourierSolver1dHomo(I, f, c, U_0, U_L, L, n, dt, tstop, user_action=None):

    t0 = time.clock() # measure the CPU time

    ....

    if user_action is not None: user_action(u,x,t)

    while t <= tstop:

        ....

        if user_action is not None: user_action(up,x,t)

        ....

    t1 = time.clock()
    return t1-t0

# ==============================================================================

def FourierSolver1dNotHomo(I, f, c, U_0, U_L, L, n, dt, tstop, user_action=None):

    t0 = time.clock() # measure the CPU time

    ....

    if user_action is not None: user_action(u,x,t)

    while t <= tstop:

        ....

        if user_action is not None: user_action(up,x,t)

        ....

    t1 = time.clock()
    return t1-t0

# ==============================================================================

def FDSolver1dHomo(I, f, c, U_0, U_L, L, n, dt, tstop, user_action=None, version='vectorized'):

    t0 = time.clock() # measure the CPU time

    ....

    if user_action is not None: user_action(u, x, t)

    while t <= tstop:

        ....

        if user_action is not None: user_action(up, x, t)

        ....

    t1 = time.clock()
    return t1-t0

# ==============================================================================

def FDSolver2dHomo(I,f,c,bc,Lx,Ly,nx,ny,dt,tstop,user_action=None):

    t0 = time.clock() # measure the CPU time

    ....

    if user_action is not None: user_action(u,x,y,t)

    while t<=tstop:
    
        ....
        
        if user_action is not None: user_action(up,x,y,t)
            
        ....

    t1 = time.clock()

    return t1-t0

# ==============================================================================

def polyVal(x, fjat):
    """
    Given x and fjat(xi,yi), having n values of the function f, 
    polyVal returns the value y=P(x) of the Lagrange interpolant 
    of f with order (n-1), such that yi=P(xi). 
    It uses the Neville's algorithm. 
    It returns also an error estimate dy.
    """
    xy=transpose(fjat)
    c=xy[1].astype('Float');   d=c.copy()
    jts=xy[0].astype('Float')-x
    n=size(c); 
    jD=zeros(n,Float);  
    js=argmin(fabs(jts))
    y=c[js]
    js=js-1
    for m in range(n-1):
        nn=n-m-1
        jD[0:nn]=jts[0:nn]-jts[1+m:n]
        if (sometrue(jD[0:nn] == 0.0)):
            print'polyVal: calculation failure'
        jD[0:nn]=(c[1:n-m]-d[0:nn])/jD[0:nn]
        d[0:nn]=jts[1+m:n]*jD[0:nn]
        c[0:nn]=jts[0:nn]*jD[0:nn]
        if (2*js < nn-1):
            dy=c[js+1]
        else:
            dy=d[js]
            js=js-1
        y=y+dy  #end do
        # dy error in convergence
    return y

def testpolyVal():
    t0=time.clock()
    x=arange(0.,pi,pi/100.)
    y=sin(x)
    fjat=transpose([x,y])
    #print fjat
    for xp in arange(0.,pi,pi/1001.): 
        pv=polyVal(xp,fjat)
        #print xp, sin(xp)- pv
    print 'time ',time.clock()-t0
