#include <math.h>
#include <stdio.h>

float fwave(float t, float efhz)
{
  static int icall=0;
  static float pi,pi2,agauss,tcut;
  float s,tmp;

/*  printf("in fwave_1 %f %f\n",t,efhz);fflush(stdout);*/
  if (icall == 0 ) {
    icall=1;
    pi=4.*atan(1.);
    pi2=2.*pi;
    agauss=0.5*efhz;
    tcut=1.5/agauss;
  }

  s=(t-tcut)*agauss;
  tmp=0;
  if (fabs(s) < 4.) tmp=exp(-2.*s*s)*cos(pi2*s);
/*  printf("in fwave_2 %f %f %f\n",t,efhz,tmp);fflush(stdout);*/
  return tmp; 
}

float fwaves(float t, float efhz)
{
  static int icall=0;
  static float pi,pi2,agauss,tcut;
  float s,tmp;

/*  printf("in fwave_1 %f %f\n",t,efhz);fflush(stdout);*/
  if (icall == 0 ) {
    icall=1;
    pi=4.*atan(1.);
    pi2=2.*pi;
    agauss=0.5*efhz;
    tcut=1.5/agauss;
  }

  s=(t-tcut)*agauss;
  tmp=0;
  if (fabs(s) < 4.) tmp=-exp(-2.*s*s)*(4.*s*cos(pi2*s)+ 2.*pi*sin(pi2*s));
/*  printf("in fwave_2 %f %f %f\n",t,efhz,tmp);fflush(stdout);*/
  return tmp; 
}
