import Gnuplot, Gnuplot.funcutils, time, wx
from SismoVi import *

class Visualizer1d:
    def __init__(self,n,t,params=[]):
        self.g = Gnuplot.Gnuplot(debug=1)
        self.g('set parametric')
        self.g('set data style lines')
        self.g('set yrange [-1:1]')
        for i in params:
            self.g(i)
    def __call__(self,u,x,t):
        self.g.plot(u)
    def end(self):
        #raw_input('Please press return to continue...\n')
        pass

class Visualizer2d:
    def __init__(self, plot=0):
        self.plot = plot
        if self.plot:
            self.g = Gnuplot.Gnuplot(persist=1)
            self.g('set parametric')
            self.g('set data style lines')
            #self.g('set hidden')
            self.g('set contour base')
            self.g('set zrange [-0.7:0.7]') # nice plot...
    def __call__(self, u, x, y, t):
        if self.plot:
            data = Gnuplot.GridData(u, x, y, binary=0)
            self.g.splot(data)
        if self.plot == 2:
            self.g.hardcopy(filename='tmp_%020f.ps' % t,
                            enhanced=1, mode='eps', fontsize=14,
                            color=0, fontname='Times-Roman')
            time.sleep(0.8) # pause to finish plot
    def end(self):
        #raw_input('Please press return to continue...\n')
        pass

class VisualizerTrace:
    def __init__(self,n,t):
        self.traces=t
        self.samples=n
        self.tx2=[]
    def __call__(self,u,x,t):
        for i in range(self.samples):
            self.tx2.append(u[i])
    def end(self):
        tx3={'traces':self.traces, 'samples':self.samples, 'tracestep':1, 'timestep':1, 'overlap':90, 'data':self.tx2}
        app=wx.PySimpleApp()
        frame=PlotFrame(None,-1,'SismoVi')
        frame.Show(True)
        frame.params.SetValues(tx3)
        frame.params.OnSubmit(None)
        #frame.params.Show(True)
        app.MainLoop()
