real  FUNCTION FWAVE(TIME,EFHZ)
!
! --- Ricker wavelet ---
!
  implicit none
  SAVE

  integer :: ienter
  real :: time, efhz
  real :: pi, pi2, agauss, tcut, s

  DATA IENTER/0/
  IF(IENTER.EQ.0) THEN
     IENTER=1
     PI=3.14159265
     PI2=2.*PI
     AGAUSS=0.5*EFHZ
     TCUT=1.5/AGAUSS
  END IF
  s=(time-tcut)*agauss
  fwave=0.
  if(abs(s).lt.4.) fwave=exp(-2.*s*s)*cos(pi2*s)
  return
end FUNCTION FWAVE
