subroutine difz2d(vin, vout, ckz, nx, nz)
implicit none
save icall, cx
integer :: i, k, icall=0, nx, nz
real, dimension (:,:) :: vin, vout
complex, dimension (:) :: ckz

complex, allocatable, dimension (:) :: cx

if (icall == 0) then
  icall = 1
  allocate(cx(nz))
  print*,icall
endif


do i=1, nx
   do k=1, nz
      cx(k) = vin(i,k)
   end do

   call ffork(nz,cx,-1.)

   do k=1, nz
      cx(k) = cx(k)*ckz(k)
   end do

   call ffork(nz,cx,1.)

   do k=1, nz
      vout(i,k) = real(cx(k))
   end do
end do

end subroutine difz2d
