subroutine difx2d(vin, vout, ckx, nx, nz)
implicit none
save icall, cx
integer :: i, k, icall=0, nx, nz
real, dimension (:,:) :: vin, vout
complex, dimension (:) :: ckx

complex, allocatable, dimension (:) :: cx

if (icall == 0) then
  icall = 1
  print*,icall
  allocate(cx(nx))
endif


do k=1, nz
   do i=1, nx
      cx(i) = vin(i,k)
   end do

   call ffork(nx,cx,-1.)

   do i=1, nx
      cx(i) = cx(i)*ckx(i)
   end do

   call ffork(nx,cx,1.)

   do i=1, nx
      vout(i,k) = real(cx(i))
   end do
end do

end subroutine difx2d
