program ac1d
!
! acoustic 2-D Fourier modelling program
!

! declaration of variables

implicit none

integer :: i, isx, k, l, nt, nx
real :: amx, arg, c, cmax, dx, efhz, pi, dt, dt2, time, tmax, tmp
real, allocatable, dimension (:) :: p, pp, c2, aux
complex, allocatable, dimension (:) :: ckx

interface 
   subroutine wavnum(ck,n,d,iord)

     integer :: iord, n
     real :: d
     complex, dimension (:) :: ck
     
   end subroutine wavnum

   subroutine difx(vin, vout, ckx, nx)
     integer :: nx
     real, dimension (:) :: vin, vout
     complex, dimension (:) :: ckx
   end subroutine difx

   real  FUNCTION FWAVE(TIME,EFHZ)
     real :: time, efhz
   end FUNCTION FWAVE
end interface

! initialization of variables

nx = 128
pi = 4.*atan(1.)
dx = 10.
efhz = 100.
c = 2000.
isx = 32
tmax = 0.5

allocate(p(nx), pp(nx), c2(nx), aux(nx), ckx(nx))

call wavnum(ckx,nx,dx,2)

do i=1, nx
   p(i) = 0.
   pp(i) = 0.
   c2(i) = c*c
end do

!c = 4000.
!do i=65,nx
!   c2(i) = c*c
!end do

cmax=0.
do i=1,nx
   cmax = amax1(cmax,sqrt(c2(i)))
end do

dt = 2*dx/(pi*cmax) * 0.2
dt2 = dt * dt
nt = tmax/dt

! loop over time steps

do l=1, nt
   time = l * dt

   call difx(p,aux,ckx,nx)

   do i=1,nx
      aux(i) = aux(i)*c2(i)
   end do

   aux(isx) = aux(isx) + FWAVE(TIME,EFHZ)

   do i=1,nx
      pp(i) = -pp(i) + 2.*p(i) + dt2 * aux(i)
   end do

   do i=1,nx
      tmp = pp(i)
      pp(i) = p(i)
      p(i) = tmp
   end do
   
   amx = 0.
   do i=1, nx
      amx = amax1(amx,abs(p(i)))
   end do
   print*,l,amx

   write(10) p

end do

end program ac1d
