#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "cwp.h"

void difz2d(float **vin, float **vout, complex* ckz, int nx, int nz)
{
  int i, k;
  float tmp;
  complex *z;
  
  void pfacc (int isign, int n, complex z[]);

  z = (complex*) alloc1(nz,sizeof(complex));

  for (i=0; i<nx; i++) {
    for (k=0; k<nz; k++) {
      z[k].r = vin[k][i];
      z[k].i = 0.;
    }
  
    pfacc(-1, nz, z);
    
    for (k=0; k<nz; k++) {
      tmp = z[k].r*ckz[k].r - z[k].i*ckz[k].i;
      z[k].i = z[k].r*ckz[k].i + z[k].i*ckz[k].r;
      z[k].r = tmp;
    }

    pfacc(1, nz, z);

    for (k=0; k<nz; k++) {
      vout[k][i] = z[k].r/nz;
    }
  }

}
