#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "cwp.h"

void difx2d(float **vin, float **vout, complex* ckx, int nx, int nz)
{
  int i, k;
  float tmp;
  complex *z;
  
  void pfacc (int isign, int n, complex z[]);

  z = (complex*) alloc1(nx,sizeof(complex));

  for (k=0; k<nz; k++) {
    for (i=0; i<nx; i++) {
      z[i].r = vin[k][i];
      z[i].i = 0.;
    }
  
    pfacc(-1, nx, z);
    
    for (i=0; i<nx; i++) {
      tmp = z[i].r*ckx[i].r - z[i].i*ckx[i].i;
      z[i].i = z[i].r*ckx[i].i + z[i].i*ckx[i].r;
      z[i].r = tmp;
    }

    pfacc(1, nx, z);

    for (i=0; i<nx; i++) {
      vout[k][i] = z[i].r/nx;
    }
  }

}
