#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "cwp.h"

main()
{
  int i, isx, isz, k, l, nt, nx, nz;
  float amx, c, dt, dt2, dx, dz, efhz, pi, t, tmax, tmp;
  float *bufz;
  float **p , **pp, **c2, **a1, **a2, **tmpp;
  complex *ckx, *ckz;
  FILE *fp, *fpsn;

  void wavnum(complex *ck, int n, float d, int iord);
  void difx2d(float **vin, float **vout, complex* ckx, int nx, int nz);
  void difz2d(float **vin, float **vout, complex* ckz, int nx, int nz);
  float fwave(float t, float efhz);

  nx = 130;
  nz = 130;

  isx = 32;
  isz = 56;

  bufz = (float*) malloc(nz*sizeof(float));
  p = (float**) alloc2(nx,nz,sizeof(float));
  pp = (float**) alloc2(nx,nz,sizeof(float));
  c2 = (float**) alloc2(nx,nz,sizeof(float));
  a1 = (float**) alloc2(nx,nz,sizeof(float));
  a2 = (float**) alloc2(nx,nz,sizeof(float));
  ckx = (complex*) alloc1(nx,sizeof(complex));
  ckz = (complex*) alloc1(nz,sizeof(complex));

  pi = 4.*atan(1.);

  dx = 10.;
  dz = 10.;
  efhz = 100.;

  tmax = 0.25;
  c = 2000.;

  dt = sqrt(2.)*dx/(pi*c) * 0.2;
  dt2 = dt*dt;

  nt = tmax/dt;
  for (k=0; k<nz; k++) {
    for (i=0; i<nx; i++) {
      p[k][i] = pp[k][i] = 0.;
      c2[k][i] = c*c;
    }
  }

  c = 4000.;
  for (k=65; k<nz; k++) {
    for (i=0; i<nx; i++) {
      c2[k][i] = c*c;
    }
  }

  wavnum(ckx,nx,dx,2);
  wavnum(ckz,nz,dz,2);
  fp = fopen("section","w");
  fpsn = fopen("snapshot","w");

  for(l=0; l<nt; l++) {
    t = l*dt;

    difx2d(p,a1,ckx,nx,nz);
    difz2d(p,a2,ckz,nx,nz);
    for (k=0; k<nz; k++) {
      for (i=0; i<nx; i++) a1[k][i] = (a1[k][i] + a2[k][i])*c2[k][i];
    }
    a1[isz][isx] += fwave(t,efhz);
    
    for (k=0; k<nz; k++) {
      for (i=0; i<nx; i++) pp[k][i] = -pp[k][i] + 2.*p[k][i] + dt2*a1[k][i];
    }

    tmpp = pp;
    pp = p;
    p = tmpp;

    amx = 0.;
    for (k=0; k<nz; k++) {
      for (i=0; i<nx; i++) {
	tmp = fabs(p[k][i]);
	amx = (amx < tmp ? tmp : amx);
      }
    }

    printf("%d %e\n",l,amx);

    /* section */
    fwrite(p, sizeof(float), nx, fp);

    /* snapshots */
    if (!(l % 10)) {
      for (i=0; i<nx; i++) {
	for (k=0; k<nz; k++) bufz[k] = p[k][i];
	fwrite(bufz, sizeof(float), nz, fpsn);
      }
    }
	
  }
  fclose(fp);
  fclose(fpsn);

}
