#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "cwp.h"

main()
{
  int i, isx, l, nt, nx;
  float amx, c, dt, dt2, dx, efhz, pi, t, tmax, tmp;
  float *p , *pp, *c2, *a, *tmpp;
  complex *ckx;
  FILE *fp;

  void wavnum(complex *ck, int n, float d, int iord);
  void difx(float *vin, float *vout, complex* ckx, int nx);
  float fwave(float t, float efhz);

  nx = 130;

  isx = 32;

  p = (float*) alloc1(nx,sizeof(float));
  pp = (float*) alloc1(nx,sizeof(float));
  c2 = (float*) alloc1(nx,sizeof(float));
  a = (float*) alloc1(nx,sizeof(float));
  ckx = (complex*) alloc1(nx,sizeof(complex));

  pi = 4.*atan(1.);

  dx = 10.;
  efhz = 100.;

  tmax = 0.5;
  c = 2000.;

  dt = 2.*dx/(pi*c) * 0.2;
  dt2 = dt*dt;

  nt = tmax/dt;

  for (i=0; i<nx; i++) {
    p[i] = pp[i] = 0.;
    c2[i] = c*c;
  }

  wavnum(ckx,nx,dx,2);
  fp = fopen("section","w");

  for(l=0; l<nt; l++) {
    t = l*dt;

    difx(p,a,ckx,nx);
    for (i=0; i<nx; i++) a[i] = a[i] *c2[i];
    a[isx] += fwave(t,efhz);
    
    for (i=0; i<nx; i++) pp[i] = -pp[i] + 2.*p[i] + dt2*a[i];

    tmpp = pp;
    pp = p;
    p = tmpp;

    amx = 0.;
    for (i=0; i<nx; i++) {
      tmp = fabs(p[i]);
      amx = (amx < tmp ? tmp : amx);
    }
    printf("%d %e\n",l,amx);

    fwrite(p, sizeof(float), nx, fp);
  }
  fclose(fp);

}
